/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.recipe.bamboo_tray;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.NewRegistryEvent;
import org.jetbrains.annotations.Nullable;

public abstract class BambooTraySingleInRecipe
implements Recipe<RecipeWrapper> {
    protected final ResourceLocation id;
    protected final String group;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final int workTime;

    public BambooTraySingleInRecipe(ResourceLocation idIn, String groupIn, Ingredient ingredientIn, ItemStack resultIn, int workTime) {
        this.id = idIn;
        this.group = groupIn;
        this.ingredient = ingredientIn;
        this.result = resultIn;
        this.workTime = workTime;
    }

    public boolean matches(RecipeWrapper inv, Level worldIn) {
        return this.ingredient.test(inv.m_8020_(0));
    }

    public ItemStack assemble(RecipeWrapper p_44001_, RegistryAccess p_267165_) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.getIngredient()});
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public ItemStack getRecipeOutput() {
        return this.result;
    }

    public int getWorkTime() {
        return this.workTime;
    }

    public String m_6076_() {
        return this.group;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public static class BambooTraySingleInRecipeSerializer<T extends BambooTraySingleInRecipe>
    extends NewRegistryEvent
    implements RecipeSerializer<T> {
        private final int workTime;
        private final IFactory<T> factory;

        public BambooTraySingleInRecipeSerializer(IFactory<T> factory, int timeIn) {
            this.workTime = timeIn;
            this.factory = factory;
        }

        public T fromJson(ResourceLocation recipeId, JsonObject json) {
            ItemStack result;
            String group = json.has("group") ? json.get("group").getAsString() : "";
            JsonElement jsonelement = json.get("ingredient");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonelement);
            if (!json.has("result")) {
                throw new JsonSyntaxException("Missing result, expected to find a string or object");
            }
            if (json.get("result").isJsonObject()) {
                result = ShapedRecipe.m_151274_((JsonObject)json.getAsJsonObject("result"));
            } else {
                result = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(json.get("result").getAsString())));
                if (result.m_41619_()) {
                    throw new JsonSyntaxException("Result cannot be null");
                }
            }
            int i = json.has("work_time") ? json.get("work_time").getAsInt() : this.workTime;
            return this.factory.create(recipeId, group, ingredient, result, i);
        }

        @Nullable
        public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack itemstack = buffer.m_130267_();
            int i = buffer.m_130242_();
            return this.factory.create(recipeId, group, ingredient, itemstack, i);
        }

        public void toNetwork(FriendlyByteBuf buffer, BambooTraySingleInRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            recipe.getIngredient().m_43923_(buffer);
            buffer.writeItemStack(recipe.getRecipeOutput(), false);
            buffer.m_130130_(recipe.getWorkTime());
        }

        public static interface IFactory<T extends BambooTraySingleInRecipe> {
            public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4, int var5);
        }
    }
}

